import viz
import vizact
import viztask
import vizcam
import vizshape
import vizfx
import random as rd
import os
current_folder = os.getcwd()
os.chdir('../')
from FlickerArray import FlickerArray
os.chdir(current_folder)
import json

# Main camera is facing z+
# Initialize Vizard and main view:
viz.setMultiSample(4)
viz.fov(60)
viz.clearcolor([0.5, 0.5, 0.5])
viz.go()
 

with open('./pars_attached.json') as pars_file:    
        dpars = json.load(pars_file)

# Scene Parameters
resolution = dpars["RESOLUTION"]
nb_layers = dpars["N"] # for now we used as much depth as there are objects to display
window = viz.MainWindow
w, h = resolution[0], resolution[1]
# window.ortho(-w/2,w/2,-h/2,h/2, -1, nb_layers+1)
main_camera = viz.MainView
main_camera.getHeadLight().disable()
main_camera.setPosition([0, 1.80, -2])
main_camera.lookAt([0,0,1])

light = viz.addLight()
light.setEuler( 0, 0 ,0 )
light = viz.addLight()
light.setEuler( -90, 0 ,0 )
vizcam.WalkNavigate()



# Stimulus initialisation
piazza = viz.addChild('piazza.osgb')
# flicker = FlickerArray(dpars, parent=main_camera)
flicker = FlickerArray(dpars, parent=main_camera)
flicker.startFlickerAction()
flicker.startRotationAction()
flicker.show(True)
